const electron = require('electron');
const path = require('path');
const fs = require('fs-extra');
const cryptoXor = require('crypto-xor');

const symmetricKey = 'kVb1/3j+skZ6UtW+5u09lHN';
const { Logger } = require('../Logger');

module.exports = () => {
    /*
     * Location of license.bin depends on the OS:
     *
     * Mac OS : ~/Library/Application Support/<Your App Name>
     * Windows: C:\Users\<you>\AppData\Local\<Your App Name>
     * Linux  : ~/.config/<Your App Name></Your>
     *
     * Note: <Your App Name> is taken from the name property in package.json
     *
     * To create these license.bin files, use code such as:
     * const fs = require('fs');
     * const cryptoXor = require('crypto-xor');
     * const symmetricKey = 'kVb1/3j+skZ6UtW+5u09lHN';
     *
     * var license = fs.readFileSync('./license.json', 'utf8');
     * var cypherText = cryptoXor.encode(license, symmetricKey);
     * fs.writeFileSync('./license.bin', cypherText);
     */
    const app = electron.app ? electron.app : electron.remote.app;
    const userDataPath = app.getPath('userData');
    const licenseFile = path.join(userDataPath, 'license.bin');
    Logger.info('Looking for %s', licenseFile);
    if (!fs.existsSync(licenseFile)) {
        Logger.info('Cannot find %s', licenseFile);
        return {};
    }

    const xorredLicense = fs.readFileSync(licenseFile, 'utf8');
    const decodedLicense = cryptoXor.decode(xorredLicense, symmetricKey);
    const jsonLicense = JSON.parse(decodedLicense);
    Logger.info('Decoded License: %s', decodedLicense);

    return jsonLicense;
};
